/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AreaStats
implements Runnable {
    private Player player;
    private int size;
    private Connection conn = null;
    private String table;

    AreaStats(Connection conn, Player player, int size, String table) {
        this.player = player;
        this.size = size;
        this.conn = conn;
        this.table = table;
    }

    @Override
    public void run() {
        Statement ps = null;
        ResultSet rs = null;
        try {
            try {
                this.conn.setAutoCommit(false);
                ps = this.conn.prepareStatement("SELECT `playername`, SUM(`created`) AS `created`, SUM(`destroyed`) AS `destroyed` FROM ((SELECT `playerid`, count(`type`) AS `created`, 0 AS `destroyed` FROM `" + this.table + "` WHERE `type` > 0 AND x > ? AND x < ? AND z > ? AND z < ?\tAND `type` != `replaced` GROUP BY `playerid`) UNION (SELECT `playerid`, 0 AS `created`, count(`replaced`) AS `destroyed` FROM `" + this.table + "` INNER JOIN `lb-players`\tUSING (`playerid`) WHERE `replaced` > 0 AND x > ? AND x < ? AND z > ? AND z < ? AND `type` != `replaced` GROUP BY `playerid`)) AS t INNER JOIN `lb-players` USING (`playerid`) GROUP BY `playerid` ORDER BY SUM(`created`) + SUM(`destroyed`) DESC LIMIT 15", 2);
                ps.setInt(1, this.player.getLocation().getBlockX() - this.size);
                ps.setInt(2, this.player.getLocation().getBlockX() + this.size);
                ps.setInt(3, this.player.getLocation().getBlockZ() - this.size);
                ps.setInt(4, this.player.getLocation().getBlockZ() + this.size);
                ps.setInt(5, this.player.getLocation().getBlockX() - this.size);
                ps.setInt(6, this.player.getLocation().getBlockX() + this.size);
                ps.setInt(7, this.player.getLocation().getBlockZ() - this.size);
                ps.setInt(8, this.player.getLocation().getBlockZ() + this.size);
                rs = ps.executeQuery();
                this.player.sendMessage(ChatColor.DARK_AQUA + "Within " + this.size + " blocks of you: ");
                if (!rs.next()) {
                    this.player.sendMessage(ChatColor.DARK_AQUA + "No results found.");
                } else {
                    this.player.sendMessage(ChatColor.GOLD + String.format("%-6s %-6s %s", "Creat", "Destr", "Player"));
                    rs.beforeFirst();
                    while (rs.next()) {
                        this.player.sendMessage(ChatColor.GOLD + String.format("%-6d %-6d %s", rs.getInt("created"), rs.getInt("destroyed"), rs.getString("playername")));
                    }
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock AreaStats] SQL exception", ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex2) {
                    LogBlock.log.log(Level.SEVERE, "[LogBlock AreaStats] SQL exception on close", ex2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock AreaStats] SQL exception on close", ex);
            }
        }
    }
}

